<?php
session_start();
include "koneksi.php";

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Data Mahasiswa</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f4f6f9;
            margin: 0;
        }

        .navbar {
            background: #2c3e50;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar a {
            color: #fff;
            text-decoration: none;
            margin-right: 20px;
            font-weight: bold;
        }

        .dashboard-container {
            padding: 30px;
        }

        .user-profile {
            text-align: right;
            margin-bottom: 20px;
        }

        .logout-link {
            color: red;
            font-weight: bold;
            text-decoration: none;
        }

        .btn-tambah {
            display: inline-block;
            padding: 10px 16px;
            background: #2ecc71;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }

        th {
            background: #3498db;
            color: white;
            padding: 10px;
        }

        td {
            padding: 8px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }

        tr:hover {
            background: #f1f1f1;
        }

        .btn-edit { color: #2980b9; font-weight: bold; }
        .btn-hapus { color: #e74c3c; font-weight: bold; }
    </style>
</head>

<body>

<div class="navbar">
    <a href="#">Mahasiswa</a>
    <div>
        <a href="dashboard.php">Beranda</a>
        <a href="data_mhs.php">Data Mahasiswa</a>
        <a href="data_mk.php">Data Mata Kuliah</a>
        <a href="data_nilai.php">Data Nilai</a>
    </div>
</div>

<div class="dashboard-container">

    <div class="user-profile">
        Hi, <strong><?= htmlspecialchars($_SESSION['username']); ?></strong> |
        <a href="logout.php" class="logout-link">Logout</a>
    </div>

    <h1>DATA MAHASISWA</h1>

    <a href="tambah_mhs.php" class="btn-tambah">+ Tambah Mahasiswa</a>

    <table>
        <tr>
            <th>No</th>
            <th>NIM</th>
            <th>Nama Mahasiswa</th>
            <th>Aksi</th>
        </tr>

        <?php
        $no = 1;
        $query = mysqli_query($koneksi, "SELECT * FROM tb_mhs ORDER BY id_mhs ASC");

        if (!$query) {
            echo "<tr><td colspan='4'>Query gagal!</td></tr>";
        } elseif (mysqli_num_rows($query) == 0) {
            echo "<tr><td colspan='4'>Data mahasiswa masih kosong</td></tr>";
        } else {
            while ($d = mysqli_fetch_assoc($query)) {
        ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= htmlspecialchars($d['nim']); ?></td>
            <td><?= htmlspecialchars($d['nama_mhs']); ?></td>
            <td>
                <a href="edit_mhs.php?id_mhs=<?= $d['id_mhs']; ?>" class="btn-edit">Edit</a> |
                <a href="hapus_mhs.php?id_mhs=<?= $d['id_mhs']; ?>"
                   class="btn-hapus"
                   onclick="return confirm('Yakin ingin menghapus data ini?')">
                   Hapus
                </a>
            </td>
        </tr>
        <?php
            }
        }
        ?>
    </table>

</div>

</body>
</html>