<?php 
session_start();
if (!isset($_SESSION['username'])) {
    header("location:login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard</title>

    <style>
        body{
            margin:0;
            font-family: 'Segoe UI', Tahoma, sans-serif;
            background:#f4f6f9;
        }

        /* NAVBAR */
        .navbar{
            background:#2c3e50;
            padding:15px 30px;
            display:flex;
            justify-content:space-between;
            align-items:center;
        }

        .navbar-brand{
            color:#fff;
            font-size:20px;
            font-weight:bold;
            text-decoration:none;
        }

        .navbar-nav a{
            color:#fff;
            text-decoration:none;
            margin-left:20px;
            font-size:14px;
        }

        .navbar-nav a:hover{
            text-decoration:underline;
        }

        /* CONTAINER */
        .dashboard-container{
            padding:30px;
        }

        /* USER INFO */
        .user-profile{
            background:#fff;
            padding:15px 20px;
            border-radius:8px;
            display:flex;
            justify-content:space-between;
            align-items:center;
            margin-bottom:25px;
            box-shadow:0 2px 6px rgba(0,0,0,0.1);
        }

        .logout-link{
            color:#e74c3c;
            font-weight:bold;
            text-decoration:none;
        }

        .logout-link:hover{
            text-decoration:underline;
        }

        /* WELCOME BOX */
        .welcome-box{
            background:#fff;
            padding:35px;
            border-radius:10px;
            box-shadow:0 4px 12px rgba(0,0,0,0.1);
            text-align:center;
        }

        .welcome-box h1{
            margin-top:0;
            color:#2c3e50;
        }

        .welcome-box p{
            font-size:16px;
            color:#555;
        }
    </style>
</head>
<body>

<div class="navbar">
    <a href="#" class="navbar-brand">Dashboardku</a>
    <div class="navbar-nav">
        <a href="dashboard.php">Beranda</a>
        <a href="data_mhs.php">Data Mahasiswa</a>
        <a href="data_mk.php">Data Mata Kuliah</a>
        <a href="data_nilai.php">Data Nilai</a>
    </div>
</div>

<div class="dashboard-container">

    <div class="user-profile">
        <div>Hi, <strong><?php echo $_SESSION['username']; ?></strong> 👋</div>
        <a href="logout.php" class="logout-link">Logout</a>
    </div>

    <div class="welcome-box">
        <h1>🎓 Selamat Datang di Website SAYA</h1>
        <p>Anda login sebagai <strong><?php echo $_SESSION['username']; ?></strong></p>
        <p>Gunakan menu di atas untuk mengelola data akademik.</p>
    </div>

</div>

</body>
</html>